﻿<?LassoScript
	// Lasso Programming Challenge\r/r	
	// <http://www.lassosoft.com/community/challenge/>
	//
	// Regular Expression Challenge
	// <http://www.lassosoft.com/community/challenge/index.lasso?9294>
	//
	// See the URL above for complete details about this programming
	// challenge including the end date, goals, judging criteria, and
	// prizes.
	//
	// Instructions
	//
	// Complete the challenge by modifying the code in this file to meet
	// the goals.  You can make any modifications to this file that you
	// see fit and you can use includes if necessary.  Please include
	// the challenge name, your name and email address in any files you
	// submit.  To enter, all files should be placed in a single folder,
	// zip compressed, and sent as an email attachment to:
	//
	// <challenge@lassosoft.com>
	//
	// Corrections
	//
	// 2007-08-13 - The [Encode_TagLink] tag was fixed to return the
	// proper value for tags which require the use of the tag ID (Thanks
	// Bil).  The "wiki" formatting rules were corrected to require that
	// a line consisting of a single hyphen is converted to an <hr />
	// rather than a line with a hyphen and a space (Thanks Johan).
	//
	include:'KC_string_convert.lasso';
	
	// This tag is used to provide access to the ldml8_reference database.
	//Auth_Admin;

?><html>
	<head>
		<title>Lasso Coding Challenge - Regular Expression Challenge</title>
		<style>
			body { font-family: Verdana; font-size: 10px; width: 576px; }
			p,td,pre { font-family: Verdana; font-size: 10px; }
			th { font-family: Verdana; font-weight: bold; font-size: 10px; text-align: left; }
			h1 { font-family: Verdana; font-weight: bold; font-size: 15px; }
			hr { border: 2px solid #cccccc; }
			h1 a { text-decoration: none; color: black; }
		</style>
	</head>
	<body>
		<h1><a href="http://www.lassosoft.com/"><img src="http://www.lassosoft.com/_images/lassosoft_logo.png" align="right" width="208" height="57" border="0" /></a><a href="http://www.lassosoft.com/community/challenge/">Lasso Coding Challenge - Regular Expression Challenge</a></h1>

		<p>This challenge is divided into eight problems.  Each problem
		can be solved using the regular expression tags in Lasso.  Many
		of the problems can be solved using ['[String_ReplaceRegExp]'] and
		['[String_FindRegExp]'].  Some of the problems may require advanced
		regular expression features or the ['[RegExp]'] type from Lasso
		8.5.</p>
		
		<p>The entry with the most correct answers will be the grand
		prize winner.  Ties will be decided based on the speed and
		elegance of the answers, or by random drawing.</p>
		
		<p>Everybody who answers one or more of the problems will be
		eligible to win a prize.  Please feel free to send in your entry
		even if you were not able to complete all of the problems.  A
		runner up will be selected from among all entries who have at
		least one correct answer.</p>
		
		<p>The source code of this document contains important
		additional details and placeholders for your answers.</p>
		
		<p>See the URL <a
		href="http://www.lassosoft.com/community/challenge/index.lasso?
		9294">http://www.lassosoft.com/community/challenge/index.lasso?
		9294</a> for important details about this challenge and complete
		rules.</p>
		
		<hr />
		
		<h2>1 - Phone Numbers</h2>
		// TODO 1 - Phone Numbers
		
		<p>Reformat phone numbers from the (###) ###-#### format to read
		as ###-###-####.  For example, the phone numbers (800) 555-1212
		should be formatted as 800-555-1212.  Phone numbers in other
		formats should not be modified.</p>
		
		<?LassoScript
		
			var: 'originalText' = 'The number for toll free assistance \
			is (800) 555-1212.  LassoSofts local phone number is (954) \
			302-3526 and their toll free telephone number is \
			1-888-286-7753.';
			
			var: 'answerText' = string_convert($originalText)->cleanNumbers;
			
			// Insert regular expression code here.  Your answer should be
			// stored in the $answerText variable and $originalText should not
			// be modified.
			
		?>
		
		<p style="color: blue"><b>Original Text:</b> [Encode_HTML: $originalText]</p>
		<p style="color: red"><b>Answer:</b> [Encode_HTML: $answerText]</p>
		
		<hr />
		
		<h2>2 - White Space</h2>
		
		<p>Simplify the white space within a string.  Replace all
		sequences of white space which contain either a return \r or a
		newline \n with a single return/newline \r\n.  Replace all other
		sequences of whitespace with a single space.  White space
		includes at minimum returns \r, newlines \n, tabs \t, and
		spaces.</p>
		
		<?LassoScript
		
			var: 'originalText' = 'The   quick brown		fox 	\
			jumps		over a lazy 	 dog. 
			
\			The      five  boxing\twizards\tjump quickly.
			
\			My faxed          joke \t won a \t\
			pager      in   the  cable\tTV           quiz    show.';
			
			var: 'answerText' = string_convert($originalText)->cleanText;
			
			// Insert regular expression code here.  Your answer should be
			// stored in the $answerText variable and $originalText should not
			// be modified.
		
		?>
		
		<p style="color: blue"><b>Original Text:</b> <pre style="color: blue">[Encode_HTML: $originalText]</pre></p>
		<p style="color: red"><b>Answer:</b> <pre style="color: red">[Encode_HTML: $answerText]</pre></p>
		
		<hr />
		
		<h2>3 - Remove Duplicate Lines</h2>
		
		<p>Find and remove duplicates lines from a block of text.  The lines have
		already been sorted into alphabetical order so you know duplicates will
		be adjacent. Each line ends with a return/newline \r\n pair.</p>
		
		<?LassoScript
		
			var: 'originalText' = 'Claire Bennet\r\nD.L. Hawkins\r\n\
			Isaac Mendez\r\nMatt Parkman\r\nMatt Parkman\r\n\
			Micah Sanders\r\nMohinder Suresh\r\nMohinder Suresh\r\n\
			Mohinder Suresh\r\nMohinder Suresh\r\nNiki Sanders\r\n\
			Noah Bennet\r\nPeter Petrelli\r\nPeter Petrelli\r\n\
			Simone Deveaux\r\nSimone Deveaux\r\nSimone Deveaux';
			
			var: 'answerText' = string_convert($originalText)->dedupe;
			
			// Insert regular expression code here.  Your answer should be
			// stored in the $answerText variable and $originalText should not
			// be modified.
			
		?>
		
		<p style="color: blue"><b>Original Text:</b> <pre style="color: blue">[Encode_HTML: $originalText]</pre></p>
		<p style="color: red"><b>Answer:</b> <pre style="color: red">[Encode_HTML: $answerText]</pre></p>
		
		<hr />
		
		<h2>4 - Strip HTML</h2>
		// TODO 4 - Strip HTML
		<p>Remove all of the HTML tags from a block of text.  All opening and closing
		tags should be removed including any parameters within the tags.</p>
		
		<?LassoScript
		
			var: 'originalText' = '<b>First Name:</b> <em>John</em><br />\
			<b>Last Name:</b> <em>Doe</em><br />\
			<b>Education:<b> <em>John graduated from <a href="http://www.harvard.com"
			target="_new">Harvard University</a> with a degree in Forestry.';
			
			var: 'answerText' = '';
			
			// Insert regular expression code here.  Your answer should be
			// stored in the $answerText variable and $originalText should not
			// be modified.
			
			 	var: 'answerText' = string_convert($originalText)->plaintext;
			
		?>
		 
		<p style="color: blue"><b>Original Text:</b> [Encode_HTML: $originalText]</p>
		<p style="color: red"><b>Answer:</b> <pre>[Encode_HTML: $answerText]</pre></p>
		
		<hr />
		
		<h2>5 - Decorate Web URLs</h2>
		// TODO 5 - Decorate Web URLs
		
		<p>Automatically mark up URLs which are contained within text.
		For example, the URL http://www.lassosoft.com/ should be marked
		up as <a href="http://www.lassosoft.com/">http://www.lassosoft.com/</a>. 
		You should handle http:// and https:// links which contain valid
		URL characters including _-./?&amp;%#.  For this problem we can
		assume the text will not contain HTML.</p>
		
		<?LassoScript
		
			var: 'originalText' = 'Visit LassoSofts Web site at \
			http://www.lassosoft.com/ or write to info@lassosoft.com for \
			more information.  The Lasso Reference can be found at \
			http://reference.lassosoft.com/.';
			
			var: 'answerText' = string_convert($originalText)->html;
			
			// Insert regular expression code here.  Your answer should be
			// stored in the $answerText variable and $originalText should not
			// be modified.
			
		?>
		
		<p style="color: blue"><b>Original Text:</b> [Encode_HTML: $originalText]</p>
		<p style="color: red"><b>Answer:</b> [Encode_HTML: $answerText]</p>
		
		<hr />
		
		<h2>6 - Decorate Email Addresses</h2>
		
		<p>Automatically mark up email addresses which are contained within text.
		For example, the URL info@lassosoft.com should be marked
		up as <a href="mailto:info@lassosoft.com">info@lassosoft.com</a>. 
		You should handle email addresses which contain valid
		email characters including _-.@.  For this problem we can
		assume the text will not contain HTML.</p>
		
		<?LassoScript
		
			var: 'originalText' = 'Visit LassoSofts Web site at \
			http://www.lassosoft.com/ or write to info@lassosoft.com for \
			more information.  The Lasso Reference can be found at \
			http://reference.lassosoft.com/.';
			
			var: 'answerText' = string_convert($originalText)->html;
			
			// Insert regular expression code here.  Your answer should be
			// stored in the $answerText variable and $originalText should not
			// be modified.
			
		?>
		
		<p style="color: blue"><b>Original Text:</b> [Encode_HTML: $originalText]</p>
		<p style="color: red"><b>Answer:</b> [Encode_HTML: $answerText]</p>
		
		<hr />
		
		<h2>7 - Wiki Style Formatting</h2>
		
		<p>Process wiki style formatting commands. The idea is that these
		commands make it easier for end-users to edit the content of the
		Web page without knowing HTML.</p>
		
		<p>Formatting - The following characters surround text which
		should be formatted in a certain way. *<b>Bold</b>*,
		_<em>Emphasised</em>_, +<u>Underlined</u>+,
		-<del>Deleted</del>-, ??<cite>Cited</cite>??,
		^<sup>Superscript</sup>^, ~<sub>Subscript</sub>~,
		{{<tt>Teletype</tt>}}.</p>
		
		<p>Headers - Lines which start with H# and a space are headers. 
		The number can range from 1 to 7.</p>
		
		<h3>H3 Header</h3>
		
		<p>Rules and Spacing - Lines which contain only a - should be formatted as an &lt;hr />
		horizontal rule.  Blank lines (two returns) separate paragraphs.  Single returns are ignored.</p>
		
		<p>Lists - Any line which starts with a dash character - and a space is part of a list.  Any
		line which starts with a number sign # and a space is part of a numbered list. The bullet or
		number sign must be the first character in the line and must be fllowed by a space.</p>
		
		<table border="0" cellspacing="0" cellpadding="0"><tr>
			<td>- One<br />- Two<br />- Three</td>
			<td><ul><li>One</li><li>Two</li><li>Three</li></ul></td>
			</tr><tr>
			<td># One<br /># Two<br /># Three</td>
			<td><ol><li>One</li><li>Two</li><li>Three</li></ol></td>
		</tr></table>
		
		<p>Anchors - Hyperlinks can be added by specifying the link
		within square brackets.
		['[http://www.apple.com]'] links to <a
		href="http://www.apple.com">http://www.apple.com</a>.  The name
		for the link can be given after a vertical bar.
		['[http://www.apple.com|Apple Computer]']
		links to <a href="http://www.apple.com">Apple Computer</a>.  An
		anchor on the current page can be linked with ['[#anchor]'].</p>
		
		<p>Images - Images can be inserted into the page by specifying their name in
		exclamation points. !mylogo.gif! would insert the specified image as &lt;img src="mylogo.gif" />.
		Options for the image can be given after a vertical bar.  Options include left, right, or center
		for alignment and #x# to specify a size. !mylogo.gif|right|72x72! would insert the specified image
		as &lt;img src="mylogo.gif" align="right" width="72" height="72" />.</p>
		
		<p>Note that an image can be used
		in an anchor as ['[http://www.apple.com|!mylog.gif!]'] to generate &lta href="http://www.apple.com">&lt;img src="mylogo.gif" align="right" width="72" height="72" />&lt;/a>.</p>
		
		<?LassoScript
		
			var: 'originalText' =
			'[http://www.thriftyfun.com/|!http://www.thriftyfun.com/images/header/frugal_living_01.jpg|right!]\r\n\
			I found it so _unusual_ that he wanted to buy *ten*\r\n\
			rutabagas.  Then I realized he was probably going to make\r\n\
			[http://www.thriftyfun.com/tf36350727.tip.html|Confetti Soup] in his microwave.\r\n\
			\r\n\
			-\r\n\
			\r\n\
			H3 Ingredients\r\n\
			- 3 Tbsp. butter\r\n\
			- 1 cup cubed carrots\r\n\
			- 1 cup cubed rutabaga\r\n\
			- 1/2 cup chopped onion\r\n\
			- 1/2 cup chopped celery\r\n\
			- 1/2 cup broccoli crowns\r\n\
			- 1/2 cup cauliflower crowns\r\n\
			- 1/4 cup flour\r\n\
			- 1/2 tsp. salt\r\n\
			- 1/2 tsp. pepper\r\n\
			- 1/4 tsp. sugar\r\n\
			- 4 cups milk\r\n\
			- 1 cup shredded cheese\r\n\
			- 1 cup corn\r\n\
			- 1/2 cup peas\r\n\
			- 1 cup cubed ham\r\n\
			\r\n\
			H3 Directions\r\n\
			Combine first 7 ingredients (in 3 qt. casserole). Cover and\r\n\
			cook on high in microwave for 10 minutes. Stir in flour,\r\n\
			salt, pepper and sugar. Blend in milk. Heat for 16 minutes,\r\n\
			4 minutes at a time (stirring after each time). Stir in\r\n\
			remainder and heat another 4 minutes.';
			
			var: 'answerText' = string_convert($originalText)->wiki;
			
			// Insert regular expression code here.  Your answer should be
			// stored in the $answerText variable and $originalText should not
			// be modified.
			
		?>
		
		<p style="color: blue"><b>Original Text:</b> <pre style="color: blue">[Encode_HTML: $originalText]</pre></p>
		<p style="color: red"><b>Answer:</b><pre>[Encode_HTML: $answerText]</pre></p>

		<hr />
		
		<h2>8 - Lasso Reference Links</h2>
		
		<p>Link Lasso tag names to the Lasso Reference automatically. 
		In our documentation we always specify tag names as
		['[Field]'] with the name of the tag in
		square brackets. Container tags are specified as
		['[Records] ... [/Records]'].  Groups of tags
		are specified as ['[Link_...]'].  Command tags
		such as -Database and -Table may also be linked.  It is not necessary
		to link symbols or data types.</p>
		
		<p>A function is provided which takes a tag name and returns a link to
		the Lasso Reference.  It uses the local Lasso Reference database to determine
		if a tag name is documented or not.  If the function returns the empty
		string then no link should be provided.</p>
		
		<?LassoScript

				// [Enccode_TagLink]
				// This tag helps assemble a link to the online Lasso Reference in the proper format.
				// It encodes a subset of URL characters, strips off closing container tags, and uses 
				// the tag's ID if the tag name contains certain invalid characters.
				Define_Tag: 'encode_taglink', -Required='value';
					Local: 'output' = #value;
					If: #output->(EndsWith: '...]');
						#output->(Replace: '...]', '');
					Else: (#output >> '...');
						#output = (String_ReplaceRegExp: #output, -Find=' ?\\.\\.\\..*', -Replace='');
					Else: (#output >> ' ') || #output->(BeginsWith: '-');
						Inline: -Search, 
								-Log='none', 
								-Database='ldml8_reference', 
								-Table='tags', 
								-Eq, 'tag_name'=#output, 
								-MaxRecords=1, -UseLimit, 
								-ReturnField='tag_id';
							If: (Found_Count > 0);
								#output = '@' + (Field: 'tag_id');
							Else;
								Return: '';
							/If;
						/Inline;
					/If;
					#output->(Replace: '%', '%25');
					#output->(Replace: '&', '%26');
					#output->(Replace: '+', '%2b');
					#output->(Replace: '=', '%3d');
					#output->(Replace: '?', '%3f');
					#output = 'http://reference.lassosoft.com/Reference.LassoApp?' + #output;
					Return: @#output;
				/Define_Tag;
		
			var: 'originalText' = 'The Lasso Reference includes articles about every
			Lasso tag including [Field], [Records] ... [/Records], [Inline] ... [/Inline],
			[Link_...], and more.  It also has articles about inline parameter such as 
			-Search, -Add, -Update, -Database, -Table, -MaxRecords, etc.';			
			
			var: 'answerText' = string_convert($originalText)->lassoLinks;
			
			// Insert regular expression code here.  Your answer should be
			// stored in the $answerText variable and $originalText should not
			// be modified.
			
		?>
		
		<p style="color: blue"><b>Original Text:</b> [Encode_HTML: $originalText]</p>
		<p style="color: red"><b>Answer:</b> [Encode_HTML: $answerText]</p>

<hr>		
		<p>Please send any questions about the challenge to <a
		href="mailto:challenge@lassosoft.com">challenge@lassosoft.com</a>.</p>
		
		<p>Copyright 2007 LassoSoft, LLC. All Rights Reserved.</p>

	</body>
</html>